% 福岡工業大学研究論集 LaTeX テンプレート(By Jing Fu）
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{fitreport}[2025/06/19 FIT Research Bulletin Class]

\LoadClass[a4paper,9pt,twoside]{article}  % 本文フォントサイズを9ptに設定

% ページ余白設定
\RequirePackage[top=35mm, bottom=30mm, left=25mm, right=25mm]{geometry}

% フォント関連
\RequirePackage{fontspec}
\RequirePackage{xeCJK}
\setmainfont{Times New Roman}
\setCJKmainfont{MS Mincho}
\setCJKfamilyfont{gothic}{MS Gothic}
\newfontfamily\japanesefont{MS Mincho}
\setlength{\parindent}{1em}  % 和文段落冒頭の字下げ（約2文字）  % 和文段落冒頭の字下げ（全角2文字）

% その他レイアウト
\RequirePackage{titlesec}
\RequirePackage{graphicx}
\RequirePackage{fancyhdr}
\RequirePackage{multicol}
\RequirePackage{amsmath}
\RequirePackage[super]{natbib}
\RequirePackage[labelfont=bf,labelsep=space]{caption}

% ヘッダー・フッター
\pagestyle{empty}
%\fancyhf{}
\renewcommand{\headrulewidth}{0pt}
%\rfoot{\thepage}

% 2段組環境
\newenvironment{twocolumntext}{\begin{multicols}{2}}{\end{multicols}}

% セクション見出しスタイル
\titleformat{\section}{\fontsize{9pt}{11pt}\selectfont\CJKfamily{gothic}\bfseries}{\thesection\ }{1em}{}
\titleformat{\subsection}{\fontsize{9pt}{11pt}\selectfont\CJKfamily{gothic}\bfseries}{\thesubsection\ }{1em}{}
\titleformat{\subsubsection}{\fontsize{9pt}{11pt}\selectfont\CJKfamily{gothic}\bfseries}{\thesubsubsection\ }{1em}{}




% 数式番号
\numberwithin{equation}{section}

% Abstract 見出し用コマンド（中央揃え）
\newcommand{\abstracttitle}{%
  \begin{center}
    \vspace{1ex}
    {\fontsize{10pt}{10pt}\selectfont\textbf{\bfseries Abstract}\\}
    \vspace{1ex}
  \end{center}
}

% キーワードコマンド
\newcommand{\keywords}[1]{\par\vspace{1ex}\noindent\textbf{Keywords:}\ \textit{#1}}

\fancypagestyle{firstpage}{
  \fancyhf{}
  \lfoot{%
    \vspace{1ex}%
    \rule[0pt]{8cm}{0.4pt}\\[-0.3em]%
    {\fontsize{9pt}{11pt}\selectfont ＊＊＊＊年＊＊月＊＊日受付}
  }
  \renewcommand{\headrulewidth}{0pt}
  \renewcommand{\footrulewidth}{0pt}
}


\endinput
